/*
 * Copyright (C) 2014 Laboratoire ThéMA - UMR 6049 - CNRS / Université de Franche-Comté
 * http://thema.univ-fcomte.fr
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


package org.thema.graphab.metric;

import java.awt.BorderLayout;
import javax.swing.DefaultComboBoxModel;
import org.thema.graphab.Project;
import org.thema.graphab.links.Linkset;
import org.thema.graphab.links.Path;
import org.thema.graphab.metric.global.GlobalMetric;

/**
 * Dialog parameters for executing {@link BatchGraphMetricTask }
 * 
 * @author Gilles Vuidel
 */
public class BatchGraphMetricDialog extends javax.swing.JDialog {

    /** has user clicked Ok ? */
    public boolean isOk = false;
    /** the selected linkset */
    public Linkset linkset;
    /** the range of values for the graph thresholds in distance or nb links depending on distAbs */
    public double min, inc, max;
    /** the selected metric */
    public GlobalMetric metric;
    /** Is range values are in distance or in number of links ? */
    public boolean distAbs;
    /** include intra patch distance when creating the graphs ? */
    public boolean intraPatchDist;

    private Project project;

    /**
     * Creates new form BatchGraphMetricDialog 
     * @param parent the parent frame
     * @param prj the project
     */
    public BatchGraphMetricDialog(java.awt.Frame parent, Project prj) {
        super(parent, true);
        initComponents();
        setLocationRelativeTo(parent);
        getRootPane().setDefaultButton(okButton);
        project = prj;

        distComboBox.setModel(new DefaultComboBoxModel(prj.getLinksets().toArray()));
        indiceComboBox.setMetrics(Project.getGlobalMetricsFor(Project.Method.GLOBAL));

        distComboBoxActionPerformed(null);
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonGroup2 = new javax.swing.ButtonGroup();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        minSpinner = new javax.swing.JSpinner();
        maxSpinner = new javax.swing.JSpinner();
        incSpinner = new javax.swing.JSpinner();
        jLabel4 = new javax.swing.JLabel();
        distTypeRadioButton = new javax.swing.JRadioButton();
        nbLinkRadioButton = new javax.swing.JRadioButton();
        distComboBox = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();
        intraPatchCheckBox = new javax.swing.JCheckBox();
        paramPanel = new javax.swing.JPanel();
        indiceComboBox = new org.thema.graphab.metric.MetricComboBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/thema/graphab/Bundle"); // NOI18N
        setTitle(bundle.getString("BatchGraphMetricDialog.title")); // NOI18N

        java.util.ResourceBundle bundle1 = java.util.ResourceBundle.getBundle("org/thema/graphab/metric/Bundle"); // NOI18N
        okButton.setText(bundle1.getString("BatchGraphMetricDialog.okButton.text")); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cancelButton.setText(bundle1.getString("BatchGraphMetricDialog.cancelButton.text")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        jLabel2.setText(bundle1.getString("BatchGraphMetricDialog.jLabel2.text")); // NOI18N

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle1.getString("BatchGraphMetricDialog.jPanel1.border.title"))); // NOI18N

        jLabel1.setText(bundle1.getString("BatchGraphMetricDialog.jLabel1.text")); // NOI18N

        jLabel3.setText(bundle1.getString("BatchGraphMetricDialog.jLabel3.text")); // NOI18N

        minSpinner.setModel(new javax.swing.SpinnerNumberModel(Double.valueOf(0.0d), Double.valueOf(0.0d), null, Double.valueOf(1.0d)));

        maxSpinner.setModel(new javax.swing.SpinnerNumberModel(Double.valueOf(1.0d), Double.valueOf(0.0d), null, Double.valueOf(1.0d)));

        incSpinner.setModel(new javax.swing.SpinnerNumberModel(Double.valueOf(1.0d), Double.valueOf(0.0d), null, Double.valueOf(1.0d)));

        jLabel4.setText(bundle1.getString("BatchGraphMetricDialog.jLabel4.text")); // NOI18N

        buttonGroup2.add(distTypeRadioButton);
        distTypeRadioButton.setSelected(true);
        distTypeRadioButton.setText(bundle1.getString("BatchGraphMetricDialog.distTypeRadioButton.text")); // NOI18N

        buttonGroup2.add(nbLinkRadioButton);
        nbLinkRadioButton.setText(bundle1.getString("BatchGraphMetricDialog.nbLinkRadioButton.text")); // NOI18N
        nbLinkRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                absTypeActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel1)
                            .add(jLabel4)
                            .add(jLabel3))
                        .add(12, 12, 12)
                        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(incSpinner, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 134, Short.MAX_VALUE)
                            .add(maxSpinner)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, minSpinner)))
                    .add(distTypeRadioButton)
                    .add(nbLinkRadioButton))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1Layout.createSequentialGroup()
                .add(distTypeRadioButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(nbLinkRadioButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 55, Short.MAX_VALUE)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(minSpinner, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(maxSpinner, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel3))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(incSpinner, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel4))
                .addContainerGap())
        );

        distComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                distComboBoxActionPerformed(evt);
            }
        });

        jLabel5.setText(bundle1.getString("BatchGraphMetricDialog.jLabel5.text")); // NOI18N

        intraPatchCheckBox.setSelected(true);
        intraPatchCheckBox.setText(bundle1.getString("BatchGraphMetricDialog.intraPatchCheckBox.text")); // NOI18N

        paramPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle1.getString("BatchGraphMetricDialog.paramPanel.border.title"))); // NOI18N
        paramPanel.setLayout(new java.awt.BorderLayout());

        indiceComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                indiceComboBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(jLabel5)
                        .add(16, 16, 16)
                        .add(distComboBox, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .add(jLabel2)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(layout.createSequentialGroup()
                                .add(intraPatchCheckBox)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .add(okButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 67, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(18, 18, 18)
                                .add(cancelButton))
                            .add(layout.createSequentialGroup()
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(paramPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .add(indiceComboBox, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                        .add(6, 6, 6)))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {cancelButton, okButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(distComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel5))
                .add(18, 18, 18)
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(indiceComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 27, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(paramPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                        .add(cancelButton)
                        .add(okButton))
                    .add(intraPatchCheckBox))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        linkset = (Linkset)distComboBox.getSelectedItem();
        min = (Double)minSpinner.getValue();
        inc = (Double)incSpinner.getValue();
        max = (Double)maxSpinner.getValue();
        metric = (GlobalMetric) indiceComboBox.getSelectedItem();

        distAbs = distTypeRadioButton.isSelected();
        intraPatchDist = intraPatchCheckBox.isSelected();
        metric.setParams(((ParamPanel)paramPanel.getComponent(0)).getParams());
        isOk = true;
        setVisible(false);
        dispose();
    }//GEN-LAST:event_okButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        setVisible(false);
        dispose();
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void distComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_distComboBoxActionPerformed
        max = 0;
        Linkset linkset = (Linkset) distComboBox.getSelectedItem();
        if(distTypeRadioButton.isSelected()) {
            for(Path p : linkset.getPaths())  {
                double v = linkset.getType_length() == Linkset.COST_LENGTH ? p.getCost() : p.getDist();
                if(v > max) {
                    max = v;
                }
            }
            max++;
        }
        else {
            max = linkset.getPaths().size();
        }

        maxSpinner.setValue(max);
    }//GEN-LAST:event_distComboBoxActionPerformed

    private void absTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_absTypeActionPerformed
        distComboBoxActionPerformed(null);
}//GEN-LAST:event_absTypeActionPerformed

    private void indiceComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_indiceComboBoxActionPerformed
        paramPanel.removeAll();
        Metric ind = (Metric) indiceComboBox.getSelectedItem();
        paramPanel.add(ind.getParamPanel(project), BorderLayout.CENTER);
        paramPanel.revalidate();
        paramPanel.repaint();
    }//GEN-LAST:event_indiceComboBoxActionPerformed



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.ButtonGroup buttonGroup2;
    private javax.swing.JButton cancelButton;
    private javax.swing.JComboBox distComboBox;
    private javax.swing.JRadioButton distTypeRadioButton;
    private javax.swing.JSpinner incSpinner;
    private org.thema.graphab.metric.MetricComboBox indiceComboBox;
    private javax.swing.JCheckBox intraPatchCheckBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JSpinner maxSpinner;
    private javax.swing.JSpinner minSpinner;
    private javax.swing.JRadioButton nbLinkRadioButton;
    private javax.swing.JButton okButton;
    private javax.swing.JPanel paramPanel;
    // End of variables declaration//GEN-END:variables

}
